function Figure1G
% Running this script produces the plots shown in Figure 1G

mAb_names = {'Negative','CR9501','5C4','ADI-19425','Motav','101F','ADI-14359','ADI-14353'};

% C3-positive percentages:
mAb(1,:) = [0.037495 0.028746 0.0094091]*100;
mAb(2,:) = [0.035018 0.080264 0.055578]*100;
mAb(3,:) = [0.031231 0.045276 0.015595]*100;
mAb(4,:) = [0.017413 0.018174 0.0062036]*100;
mAb(5,:) = [0.032129 0.031084 0.026587]*100;
mAb(6,:) = [0.059297 0.13665 0.050686]*100;
mAb(7,:) = [0.10851 0.22369 0.088365]*100;
mAb(8,:) = [0.3048 0.60406 0.31649]*100;

dq = 0.2*(rand(size(mAb))-.5);
q = [ [0:7]' [0:7]' [0:7]'] + dq;
for k = 0:7
  semilogy([k-.5 k+.5],mean(mAb(k+1,:))*[1 1],'k'); hold on;
end
semilogy(q(:,1),mAb(:,1),'s','MarkerSize',8,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]);
semilogy(q(:,2),mAb(:,2),'s','MarkerSize',8,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); 
semilogy(q(:,3),mAb(:,3),'s','MarkerSize',8,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); hold off;
xticks([0:7]);
xticklabels(mAb_names); xtickangle(45);
title('Post-F Data')
ylim([0.3 100])
ylabel('Percent C3-positive particles')
clear

%==========================================================================
% mAb:F data
m101F = [0.30497 0.18355 0.16059];
m5C4 = [0.081405 0.041964 0.023032];
m14353 = [0.15542 0.12024 0.10676];
m14359 = [0.12546 0.085728 0.076273];
m19425 = [0.037616 0.029924 0.019436];
mCR9501 = [0.075522 0.035262 0.022911];
mMot = [0.39899 0.19081 0.2026];
neg = [0.0014659 0.0015742 0.0023121];

mAb_names = {'Negative','CR9501','5C4','ADI-19425','Motav','101F','ADI-14359','ADI-14353'};
figure;
q = 0; dq = [-.1 0 .1];
semilogy(q+dq,neg,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); hold on; q = q + 1;
semilogy(q+dq,mCR9501,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); q = q + 1;
semilogy(q+dq,m5C4,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); q = q + 1;
semilogy(q+dq,m19425,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); q = q + 1;
semilogy(q+dq,mMot,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); q = q + 1;
semilogy(q+dq,m101F,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); q = q + 1;
semilogy(q+dq,m14359,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); q = q + 1;
semilogy(q+dq,m14353,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]);
ylim([0.001 1]);
xticks([0:7]);
xticklabels(mAb_names); xtickangle(45);
title('Post-F Data')
ylabel('mAb/F [AU]')